using System;
using System.Drawing;
using System.Windows.Forms;

namespace gov.va.med.vbecs.admin.GUI
{
	/// <summary>
	/// Defines base functionality for list view item used in MUC list views. 
	/// </summary>
	public abstract class BaseListViewItem : ListViewItem
	{
		/// <summary>
		/// String displayed when the item is unavailable/undefined (null).
		/// </summary>
		private const string NaStringToken = "N/A";

		/// <summary>
		/// Initializes the object.
		/// </summary>
		/// <param name="numberOfSubItems">Number of subitems.</param>
		protected BaseListViewItem( int numberOfSubItems ) : base()
		{
			this.SubItems.AddRange( GetEmptySubItems( numberOfSubItems ) );
		}

		/// <summary>
		/// Creates an array of empty subitems initialized with empty strings.
		/// </summary>
		/// <param name="numberOfSubItems">Number of subitems to create.</param>
		/// <returns>Array of empty subitems.</returns>
		protected virtual string[] GetEmptySubItems( int numberOfSubItems )
		{
			string[] _result = new string[ numberOfSubItems ];

			for( int i = 0; i < _result.Length; i++ )
				_result[i] = String.Empty;

			return _result;
		}

		/// <summary>
		/// Sets item forecolor corresponding to active/inactive item.
		/// </summary>
		/// <param name="activeIndicator">Specifies whether the item is active or inactive.</param>
		protected virtual void SetStatusForeColor( bool activeIndicator )
		{
			ForeColor = Color.FromKnownColor( activeIndicator ? KnownColor.ControlText : KnownColor.GrayText );
		}

		/// <summary>
		/// Synchronizes this list view item with a bound data object. 
		/// </summary>
		public abstract void SyncWithDataObject();

		/// <summary>
		/// String displayed when the item is unavailable/undefined (null). 
		/// Provides loose binding with constant value, allows override by derived classes.
		/// </summary>
		protected virtual string NaString
		{
			get
			{
				return NaStringToken;
			}
		}
	}
}
